﻿var openEndAnalysisTopics = {
    context: $(".open-end-analysis-topics"),
    dataTable: null,
    initialize: function () {
        openEndAnalysisTopics.initializeDataTable();
    },
    initializeDataTable: function () {
        var sentenceId = $("#SentenceId", openEndAnalysisTopics.context).val();
        openEndAnalysisTopics.dataTable = $(".data-table", this.context).a4datatable({
            height: "full",
            ajaxAction: a4.getSurveyAction("GetOpenEndAnalysisSentenceTopics", "Analyze"),
            ajaxParams: { "sentenceId": sentenceId },
            columns: [
                { "Name": "Id", "Title": resources.Id, "Visible": false, "Key": true },
                { "Name": "Text", "Title": resources.Topic, },
                { "Name": "Score", "Title": resources.Score, "Width": "80px", "Type": "Number" },
                { "Name": "Sentiment", "Title": resources.Sentiment, "Width": "150px", "Class": "sentiment-column", "Data": openEndAnalysis.renderSentimentChart, "Sortable": false }
            ],          
        });
    }
};

$(document).ready(function () {
    if (openEndAnalysisTopics.context.length > 0)
        openEndAnalysisTopics.initialize();
})